/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw;

import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.log.Logger;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.ObjectDumperAttributes;
import com.ibm.hwmca.fw.util.Trace;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public class HException
extends Exception {
    private static final String TRACE_MASKT = "XFRMHEXT";
    private static final String TRACE_MASKF = "XFRMHEXF";
    private static final String TRACE_MASKD = "XFRMHEXD";
    private boolean isLogged = false;
    private String stackTrace;
    private ArrayList dataBlocks = new ArrayList();

    public HException(String text) {
        super(text);
        Trace.trace(TRACE_MASKT, "-> HException.HException(" + text + ")");
        this.addTraceBlocks();
        Trace.trace(TRACE_MASKT, "<- HException.HException(text)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HException(Throwable thrown) {
        super(thrown instanceof HException ? thrown.getMessage() : "(From " + thrown.getClass() + ") " + thrown.getMessage());
        Trace.trace(TRACE_MASKT, "-> HException.HException(thrown)");
        StringWriter stack = new StringWriter();
        PrintWriter writer = new PrintWriter(stack);
        thrown.printStackTrace(writer);
        this.stackTrace = stack.toString();
        Trace.trace(TRACE_MASKF, this.toString());
        if (thrown instanceof HException) {
            this.setLogged(((HException)thrown).isLogged());
            ArrayList arrayList = this.dataBlocks;
            synchronized (arrayList) {
                this.dataBlocks.addAll(((HException)thrown).dataBlocks);
            }
        } else {
            this.addTraceBlocks();
        }
        Trace.trace(TRACE_MASKT, "<- HException.HException()");
    }

    public boolean isLogged() {
        return this.isLogged;
    }

    public void setLogged(boolean isLogged) {
        this.isLogged = isLogged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogBlock[] getDataBlocks() {
        LogBlock[] result = null;
        ArrayList arrayList = this.dataBlocks;
        synchronized (arrayList) {
            result = new LogBlock[this.dataBlocks.size()];
            this.dataBlocks.toArray(result);
        }
        return result;
    }

    public void add(Object data) {
        this.add((byte)-1, data, null);
    }

    public void add(byte blockId, Object data) {
        this.add(blockId, data, null);
    }

    public void add(Object data, ObjectDumperAttributes dumpAttribs) {
        this.add((byte)-1, data, dumpAttribs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte blockId, Object data, ObjectDumperAttributes dumpAttribs) {
        Trace.trace(TRACE_MASKF, "-> add(blockId=0x" + HexString.toHex(blockId, true) + ",data,dumpAttribs=" + dumpAttribs + ")");
        LogBlock logBlock = new LogBlock(blockId, data, dumpAttribs);
        ArrayList arrayList = this.dataBlocks;
        synchronized (arrayList) {
            this.dataBlocks.add(logBlock);
        }
        Trace.trace(TRACE_MASKF, "<- add()");
    }

    public void printStackTrace() {
        if (this.stackTrace == null) {
            super.printStackTrace();
        } else {
            System.out.print(this.stackTrace);
        }
    }

    public void printStackTrace(PrintWriter writer) {
        if (this.stackTrace == null) {
            super.printStackTrace(writer);
        } else {
            writer.write(this.stackTrace.toCharArray());
            writer.flush();
        }
    }

    public void printStackTrace(PrintStream stream) {
        if (this.stackTrace == null) {
            super.printStackTrace(stream);
        } else {
            stream.println(this.stackTrace);
            stream.flush();
        }
    }

    private void addTraceBlocks() {
        try {
            Trace.trace(TRACE_MASKD, "-> HException.addTraceBlocks()");
            if (CommonSystem.getCommonSystem().isLocationUnified() || CommonSystem.getCommonSystem().isLocationServer() || !(this instanceof TaskletException)) {
                Logger logger = Logger.getLogger();
                this.add((byte)-17, logger.getTrace(1), null);
                this.add((byte)-18, logger.getTrace(2), null);
                this.add((byte)-19, logger.getTrace(3), null);
            }
        }
        catch (Throwable exc) {
            Trace.trace(TRACE_MASKF, "Error adding trace blocks");
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKD, "<- HException.addTraceBlocks()");
    }
}

